package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.ApartadoAnexoI;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b73s00DaoImpl generated by UDA, 11-Jan-2017 12:23:07.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ApartadoAnexoIDaoImpl implements ApartadoAnexoIDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.APDOANX_073 APDOANX073, t1.DESANX_EU_073 DESANXEU073, t1.DESANX_ES_073 DESANXES073, t1.FECBAJ_073 FECBAJ073 FROM AB0473S00 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ApartadoAnexoI> rwMap = new RowMapper<ApartadoAnexoI>() {
		public ApartadoAnexoI mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ApartadoAnexoI(resultSet.getString("APDOANX073"), resultSet.getString("DESANXEU073"),
					resultSet.getString("DESANXES073"), resultSet.getDate("FECBAJ073"));
		}
	};

	private RowMapper<ApartadoAnexoI> rwMapPK = new RowMapper<ApartadoAnexoI>() {
		public ApartadoAnexoI mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ApartadoAnexoI(resultSet.getString("APDOANX073"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab04b73s00 table.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  Ab04b73s00
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @return the apartado anexo I
	 */
	public ApartadoAnexoI add(ApartadoAnexoI ab0473s00) {
		String query = "INSERT INTO AB0473S00 (APDOANX_073, DESANX_EU_073, DESANX_ES_073, FECBAJ_073) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, ab0473s00.getApdoanx073(), ab0473s00.getDesanxEu073(),
				ab0473s00.getDesanxEs073(), ab0473s00.getFecbaj073());
		return ab0473s00;
	}

	/**
	 * Updates a single row in the Ab04b73s00 table.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  Ab04b73s00
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @return the apartado anexo I
	 */
	public ApartadoAnexoI update(ApartadoAnexoI ab0473s00) {
		String query = "UPDATE AB0473S00 SET DESANX_EU_073 = ?, DESANX_ES_073 = ?, FECBAJ_073 = ? WHERE APDOANX_073=? ";
		this.jdbcTemplate.update(query, ab0473s00.getDesanxEu073(), ab0473s00.getDesanxEs073(),
				ab0473s00.getFecbaj073(), ab0473s00.getApdoanx073());
		return ab0473s00;
	}

	/**
	 * Finds a single row in the Ab04b73s00 table.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  Ab04b73s00
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @return the apartado anexo I
	 */
	@Transactional(readOnly = true)
	public ApartadoAnexoI find(ApartadoAnexoI ab0473s00) {
		StringBuilder query = new StringBuilder(ApartadoAnexoIDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.APDOANX_073 = ? ");

		List<ApartadoAnexoI> ab0473s00List = this.jdbcTemplate.query(query.toString(), this.rwMap,
				ab0473s00.getApdoanx073());
		return (ApartadoAnexoI) DataAccessUtils.uniqueResult(ab0473s00List);
	}

	/**
	 * Removes a single row in the Ab04b73s00 table.
	 * 
	 *  ab0473s00            Ab04b73s00
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 */
	public void remove(ApartadoAnexoI ab0473s00) {
		String query = "DELETE FROM AB0473S00 WHERE APDOANX_073=?";
		this.jdbcTemplate.update(query, ab0473s00.getApdoanx073());
	}

	/**
	 * Finds a list of rows in the Ab04b73s00 table.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab04b73s00>
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ApartadoAnexoI> findAll(ApartadoAnexoI ab0473s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(ApartadoAnexoIDaoImpl.QUERY_SELECT);
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0473s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ApartadoAnexoI>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab04b73s00 table using like.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab04b73s00>
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ApartadoAnexoI> findAllLike(ApartadoAnexoI ab0473s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(ApartadoAnexoIDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0473s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ApartadoAnexoI>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab04b73s00 table.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  Long
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ApartadoAnexoI ab0473s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB0473S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0473s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab04b73s00 table using like.
	 * 
	 *  ab0473s00
	 *            Ab04b73s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ApartadoAnexoI ab0473s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB0473S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0473s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab04b73s00 selected for rup_table.
	 * 
	 *  ab0473s00            Ab04b73s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab04b73s00>>
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ApartadoAnexoI>> reorderSelection(ApartadoAnexoI ab0473s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(ApartadoAnexoIDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0473s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto,
				ApartadoAnexoI.class, filterParamList, "APDOANX_073,DESANX_EU_073,DESANX_ES_073,FECBAJ_073");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ApartadoAnexoI>(this.rwMapPK, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab04b73s00
	 *  searchParams            Ab04b73s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab04b73s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ApartadoAnexoI>> search(ApartadoAnexoI filterParams, ApartadoAnexoI searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(ApartadoAnexoIDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto,
				ApartadoAnexoI.class, filterParamList, searchSQL, searchParamList, from_alias,
				"APDOANX_073,DESANX_EU_073,DESANX_ES_073,FECBAJ_073");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ApartadoAnexoI>(this.rwMapPK, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0473s00            Ab04b73s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0473s00 the filterab 0473 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override()
	public void removeMultiple(ApartadoAnexoI filterab0473s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(ApartadoAnexoIDaoImpl.QUERY_SELECT);
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0473s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, ApartadoAnexoI.class,
				query, params, "APDOANX_073,DESANX_EU_073,DESANX_ES_073,FECBAJ_073");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b73s00 entity.
	 * 
	 *  ab0473s00            Ab04b73s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ApartadoAnexoI ab0473s00) {

		StringBuilder where = new StringBuilder(ApartadoAnexoIDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0473s00 != null && ab0473s00.getApdoanx073() != null) {
			where.append(" AND t1.APDOANX_073 = ?");
			params.add(ab0473s00.getApdoanx073());
		}
		if (ab0473s00 != null && ab0473s00.getDesanxEu073() != null) {
			where.append(" AND t1.DESANX_EU_073 = ?");
			params.add(ab0473s00.getDesanxEu073());
		}
		if (ab0473s00 != null && ab0473s00.getDesanxEs073() != null) {
			where.append(" AND t1.DESANX_ES_073 = ?");
			params.add(ab0473s00.getDesanxEs073());
		}
		if (ab0473s00 != null && ab0473s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_073 >= ?");
			params.add(ab0473s00.getFecbajaDesde());
		}
		if (ab0473s00 != null && ab0473s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_073 <= ?");
			params.add(ab0473s00.getFecbajaHasta());
		}
		//where.append(" AND (t1.FECBAJ_073 IS NULL OR t1.FECBAJ_073 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b73s00 entity.
	 * 
	 *  ab0473s00            Ab04b73s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0473s00 the ab 0473 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(ApartadoAnexoI ab0473s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ApartadoAnexoIDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0473s00 != null && ab0473s00.getApdoanx073() != null) {
			where.append(" AND UPPER(t1.APDOANX_073) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0473s00.getApdoanx073().toUpperCase() + "%");
			} else {
				params.add("%" + ab0473s00.getApdoanx073().toUpperCase() + "%");
			}
			where.append(" AND t1.APDOANX_073 IS NOT NULL");
		}
		if (ab0473s00 != null && ab0473s00.getDesanxEu073() != null) {
			where.append(" AND UPPER(t1.DESANX_EU_073) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0473s00.getDesanxEu073().toUpperCase() + "%");
			} else {
				params.add("%" + ab0473s00.getDesanxEu073().toUpperCase() + "%");
			}
			where.append(" AND t1.DESANX_EU_073 IS NOT NULL");
		}
		if (ab0473s00 != null && ab0473s00.getDesanxEs073() != null) {
			where.append(" AND UPPER(t1.DESANX_ES_073) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0473s00.getDesanxEs073().toUpperCase() + "%");
			} else {
				params.add("%" + ab0473s00.getDesanxEs073().toUpperCase() + "%");
			}
			where.append(" AND t1.DESANX_ES_073 IS NOT NULL");
		}
		if (ab0473s00 != null && ab0473s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_073 >= ?");
			params.add(ab0473s00.getFecbajaDesde());
		}
		if (ab0473s00 != null && ab0473s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_073 <= ?");
			params.add(ab0473s00.getFecbajaHasta());
		}
		if(ab0473s00 != null && ab0473s00.getFecbajaDesde() == null && ab0473s00.getFecbajaHasta() == null){
			where.append(" AND (t1.FECBAJ_073 IS NULL OR t1.FECBAJ_073 > SYSDATE)");
		}
		//where.append(" AND (t1.FECBAJ_073 IS NULL OR t1.FECBAJ_073 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
